/****************************************************************************

    LLLIB1.H           Version 1.00 / May 1997

    
    Distribution version of header file for Licensing Library

****************************************************************************/



#ifndef __LLLIB1_H__
#define __LLLIB1_H__



// Convert 16 bit definitions
#ifndef WIN32
#define LPCTSTR     LPCSTR
#define LPTSTR      LPSTR
#define ULONG       unsigned long;
#endif



// External declarations for user use
#ifdef __cplusplus
extern "C" {
#endif



// Definitions
#define OPTION_UNREGISTERED				'U'
#define OPTION_LIMITED                  'L'
#define OPTION_TEMPORARYREGISTRATION    'T'
#define OPTION_FULLREGISTRATION         'R'

#ifndef DllExport
#ifdef WIN32
#define DllExport __declspec(dllexport)
#else
#define DllExport _far _pascal
#endif
#endif
    
    
// Function Prototypes
void DllExport SetLicenseFile(LPCSTR);
int  DllExport SetLibraryLicense(LPCSTR);
int  DllExport WriteDefaultLicense(char, long, LPCSTR, int, int);
int  DllExport WriteLicense(LPCSTR);
int  DllExport WriteLicenseUser(LPCSTR, LPCSTR);
int  DllExport CheckLicenseNo(LPCSTR, LPCSTR, long);
int  DllExport GetLicense(LPSTR);
int  DllExport GetLicenseOption(LPSTR);
int  DllExport GetLicenseUser(LPSTR);
int  DllExport GetLicenseCompany(LPSTR);
int  DllExport GetExpiry(LPINT, LPINT, LPINT, LPINT);
    
BOOL DllExport IsLicenseLimited();
    
void DllExport CalcLicenseNo(char, long, LPCSTR, int, long, int, LPSTR);
int  DllExport ValidateLicenseNo(char, long, LPCSTR, LPCSTR);
    
void DllExport GetLicenseErrorMsg(int, LPSTR);
    
int  DllExport IncreaseLicenseRuns();
int  DllExport GetLicenseRuns();
    
int  DllExport GetLicenseUsers();
int  DllExport IncreaseLicenseUsers();
void DllExport DecreaseLicenseUsers();
int  DllExport GetFreeLicenseUsers();
int  DllExport GetUsedLicenseUsers();    



#ifdef __cplusplus
}
#endif



#endif
